import { filterEmotes } from 'web-client/helpers/filter-emotes';
import { module, test } from 'qunit';

let appModel = {
  channelProduct: {
    "name":"cereth",
    "product_url":"http://www.twitch.tv/products/cereth",
    "html":"<p class=\"title\">Subscribe to <span class=\"prod\">cereth</span>!</p>\n<br>\n\n<p class=\"message\">\nYour subscription will directly support the broadcaster and help advance the cause of professional gaming.\n</p>\n<br>\n\n<p class=\"message\">\nIt's currently only <span class=\"price\"> $4.99</span><span class=\"sub\">USD</span> per month.\n</p>\n<br>\n\n<img src=\"paywall.SubscriptionPurchaseButton\" id=\"purchase_button\" />",
    "css":"\r\np        {font-family: BestFont.HELVETICA;}\r\nli       {font-family: BestFont.HELVETICA; text-decoration: underline;}\r\n.title   {color: #FFF; font-size: 21pt;}\r\n.message {color: #CCC;font-size: 12pt;text-align: left;leading: 2.4pt;}\r\n.price   {font-size: 16pt;leading: 3.2pt;color:#EEE;}\r\n.prod    {color: #B4B9BF; font-weight: bold; }\r\n.sub     {font-size: 7pt;}\r\n.footer  {color: #DDD; font-size: 9.5pt;}\r\na        {color: #6441A5; font-family: BestFont.HELVETICA;\r\n          font-size: 12pt;\r\n          text-decoration: none;}\r\n.wait    {color: #FF2; font-size: 24;}\r\n.error   {color: #FF2; font-size: 12pt;}\r\nimg      {display: inline;}",
    "price":"$4.99",
    emoticons: [
      {
        "id":29227,
        "width":28,
        "height":28,
        "state":"active",
        "regex":"cerHug",
        "emoticon_set":155,
        "url":"http://static-cdn.jtvnw.net/jtv_user_pictures/emoticon-29227-src-919fd7863579b112-28x28.png",
        "subscriber_only":true
      },
      {
        "id":15517,
        "width":28,
        "height":28,
        "state":"active",
        "regex":"cerHype",
        "emoticon_set":155,
        "url":"http://static-cdn.jtvnw.net/jtv_user_pictures/emoticon-15517-src-d6484146acfb6347-28x28.png",
        "subscriber_only":true
      }
    ]
  },
  otherEmotes: {
    emoticon_sets: {
      "0": [
        {
          "id":25,
          "code":"Kappa"
        },
        {
          "id":88,
          "code":"PogChamp"
        },
        {
          "id":3412,
          "code":"PeoplesChamp"
        }
      ],
      "457": [
        {
          "id":2867,
          "code":"KappaHD"
        }
      ]
    }
  }
};

const emoteSets = appModel.otherEmotes.emoticon_sets;
const emoteSetsArr = Object.keys(emoteSets).map(setId => emoteSets[setId]);
const channelEmotes = appModel.channelProduct.emoticons;

module('Unit | Helper | filter emotes');

test(`Doesn't filter any emotes out when an empty string is passed`, function(assert) {
  let filteredEmotes = filterEmotes([...emoteSetsArr], {filter: ''});
  assert.equal(filteredEmotes.length, emoteSetsArr.reduce((total, emoteSet) => (total + emoteSet.length), 0));
});

test(`Filters all emotes out when a bogus string is passed`, function(assert) {
  let filteredEmotes = filterEmotes([...emoteSetsArr], {filter: '5CS1Lm5qNJ'});
  assert.equal(filteredEmotes.length, 0);
});

test(`Finds both Kappa emotes in the dummy data via case-insensitive search`, function(assert) {
  let filteredEmotes = filterEmotes([...emoteSetsArr], {filter: 'kappa'});
  assert.ok(filteredEmotes.every(({code}) => code.indexOf('Kappa') !== -1));
  assert.equal(filteredEmotes.length, 2);
});

test(`Filters can be anywhere in the emote code, not just in the beginning`, function(assert) {
  let filteredEmotes = filterEmotes([...emoteSetsArr], {filter: 'champ'});
  assert.ok(filteredEmotes.some(({code}) => code === 'PogChamp'));
  assert.ok(filteredEmotes.some(({code}) => code === 'PeoplesChamp'));
});

test(`Works with a channel-specific emote list`, function(assert) {
  let filteredEmotes = filterEmotes([channelEmotes], {filter: 'hype'});
  assert.equal(filteredEmotes.length, 1);
  assert.equal(filteredEmotes[0].regex, 'cerHype');
  assert.ok(filteredEmotes[0].subscriber_only);
});
