import { i18nSplitString } from 'web-client/helpers/i18n-split-string';
import { module, test } from 'qunit';

module('Unit | Helper | i18n split string');

const INNER = 'inner element';
const BEFORE = 'before ';
const AFTER = ' after';

test('when element at beginning of string', function (assert) {
  assert.expect(4);

  let results = i18nSplitString([`|${INNER}|${AFTER}`]);

  assert.equal(results.length, 3);
  assert.equal(results[0], "");
  assert.equal(results[1], INNER);
  assert.equal(results[2], AFTER);
});

test('when element in middle of string', function (assert) {
  assert.expect(4);

  let results = i18nSplitString([`${BEFORE}|${INNER}|${AFTER}`]);

  assert.equal(results.length, 3);
  assert.equal(results[0], BEFORE);
  assert.equal(results[1], INNER);
  assert.equal(results[2], AFTER);
});

test('when element at end of string', function (assert) {
  assert.expect(4);

  let results = i18nSplitString([`${BEFORE}|${INNER}|`]);

  assert.equal(results.length, 3);
  assert.equal(results[0], BEFORE);
  assert.equal(results[1], INNER);
  assert.equal(results[2], "");
});

