import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('is-commerce-whitelisted', {
  integration: true
});

test('returns true when service returns isWhitelisted', function(assert) {
  this.register('service:game-settings', Service.extend({
    isFlWhitelisted: true
  }));
  this.render(hbs`{{if (is-commerce-whitelisted) "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'enabled', 'is whitelisted');
});

test('returns true when service returns NOT isWhitelisted', function(assert) {
  this.register('service:game-settings', Service.extend({
    isFlWhitelisted: false
  }));
  this.render(hbs`{{if (is-commerce-whitelisted) "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'disabled', 'is whitelisted');
});

