import { isLoaded } from 'web-client/helpers/is-feature-loaded';
import { module, test } from 'qunit';

let originalFeatures;

module('Unit | Helper | is feature loaded', {
  beforeEach() {
    originalFeatures = window.features = window.features || [];
    window.features.push('features.js');
  },

  afterEach() {
    window.features = originalFeatures;
  }
});

test('it checks for loaded component module', function(assert) {
  let result = isLoaded(['features.js']);
  assert.ok(result, 'returns true for `features.js`');

});

test('returns false when the features is not loaded', function(assert) {
  let result = isLoaded(['not-a-feature']);
  assert.notOk(result, 'returns false when the feature is not loaded');
});
