import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('is-global-enabled', {
  integration: true
});

test('returns true when global is (boolean) true', function(assert) {
  this.register('service:globals', Service.extend({
    someGlobalProp: true
  }));
  this.render(hbs`{{if (is-global-enabled "someGlobalProp") "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'enabled', 'is enabled');
});

test('returns true when global is (string) true', function(assert) {
  this.register('service:globals', Service.extend({
    someGlobalProp: 'true'
  }));
  this.render(hbs`{{if (is-global-enabled "someGlobalProp") "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'enabled', 'is whitelisted');
});

test('returns false when service is (boolean) false', function(assert) {
  this.register('service:globals', Service.extend({
    someGlobalProp: false
  }));
  this.render(hbs`{{if (is-global-enabled "someGlobalProp") "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'disabled', 'is whitelisted');
});

test('returns false when service is (string) false', function(assert) {
  this.register('service:globals', Service.extend({
    someGlobalProp: 'false'
  }));
  this.render(hbs`{{if (is-global-enabled "someGlobalProp") "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'disabled', 'is whitelisted');
});

