import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('is-staff', {
  integration: true
});

test('returns true when user is staff', function(assert) {
  this.register('service:session', Service.extend({
    userData: {
      is_staff: true
    }
  }));
  this.render(hbs`{{if (is-staff) "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'enabled', 'is staff');
});

test('returns false when user is not staff', function(assert) {
  this.register('service:session', Service.extend({
    userData: {
      is_staff: false
    }
  }));
  this.render(hbs`{{if (is-staff) "enabled" "disabled"}}`);
  assert.equal(this.$().text(), 'disabled', 'is not staff');
});
