import { styledI18n } from 'web-client/helpers/styled-i18n';
import { module, test } from 'qunit';

module('Unit | Helper | styled i18n');

test('Replaces $start-bold$ and $end-bold$', function (assert) {
  assert.expect(1);

  let result = styledI18n('not bold $start-bold$is bold$end-bold$').string;
  let expected = 'not bold <span class="strong">is bold</span>';

  assert.equal(result, expected);
});

test('Replaces values using hash', function (assert) {
  assert.expect(1);

  let values = {
    first: 'foo',
    second: 'bar'
  };

  let result = styledI18n('First: %{first} Second: %{second}', values).string;
  let expected = 'First: foo Second: bar';

  assert.equal(result, expected);
});

test('Replaces values using array', function (assert) {
  assert.expect(1);

  let values = ['foo', 'bar'];

  let result = styledI18n('First: %{0} Second: %{1}', values).string;
  let expected = 'First: foo Second: bar';

  assert.equal(result, expected);
});

test('Replaces both values and styles markers', function (assert) {
  assert.expect(1);

  let values = ['foo', 'bar'];

  let result = styledI18n('First: $start-bold$%{0}$end-bold$ Second: %{1}', values).string;
  let expected = 'First: <span class="strong">foo</span> Second: bar';

  assert.equal(result, expected);
});
