import { towerPlaceholder } from 'web-client/helpers/tower-placeholder';
import { module, test } from 'qunit';

module('Unit | Helper | tower placeholder');

test('it returns ten placeholders', function(assert) {
  assert.expect(11);

  let result = towerPlaceholder();

  assert.ok(!!result.childNodes,
            'result is a document fragment with child nodes');

  // Ten child nodes expected
  for (let i = 0; i < result.childNodes.length; i++) {
    assert.strictEqual(
      result.childNodes[i].getAttribute('class'),
      'tower_placeholder',
      'child is a tower_placeholder'
    );
  }
});
