import { USDCurrency } from 'web-client/helpers/usd-currency';
import { module, test } from 'qunit';

module('Unit | Helper | usd-currency');

test('convert number greater than 10 to USD currency without cents, rounded up', function (assert) {
  let result = USDCurrency(12345.67);

  assert.equal(result, '$12,346', 'adds $ sign, commas, and strips the cents');
});

test('convert number less than or equal to 10 to USD currency with cents', function (assert) {
  let result = USDCurrency(1.23);

  assert.equal(result, '$1.23', 'adds $ sign, commas, and does not strip the cents');
});
