import run from 'ember-runloop';
import EmberObject from 'ember-object';
import { AsyncErrorHandlerMixin } from 'web-client/services/bits-room';
import { module, test } from 'qunit';
import wait from 'ember-test-helpers/wait';
import { TIMINGS } from 'web-client/utilities/bits/constants-config';

const ERROR_MOCK = {
  status: 'insufficient_balance',
  message: 'You do not have enough Bits to make this transaction'
};

module('Unit | Mixin | async error handler', {
  beforeEach() {
    TIMINGS.ERROR_DISPLAY_TIMEOUT = 0; // Don't wait 5 seconds for this test
    this.AsyncErrorHandlerMixinObject = EmberObject.extend(AsyncErrorHandlerMixin);
  }
});

test('Unsets itself', function (assert) {
  assert.expect(3);
  let subject = this.AsyncErrorHandlerMixinObject.create();
  subject.set('showAsyncError', ERROR_MOCK);
  assert.equal(subject.get('bitsAsyncErrorStatus'), ERROR_MOCK.status);
  assert.equal(subject.get('bitsAsyncErrorMessage'), ERROR_MOCK.message);
  run.later(() => {
    assert.ok(!subject.get('showAsyncError'), "showAsyncError properties are set to null afterwards");
  });
  return wait();
});

test('Teardown works', function (assert) {
  assert.expect(1);
  let subject = this.AsyncErrorHandlerMixinObject.create();
  subject.set('showAsyncError', ERROR_MOCK);
  run.cancel(subject._asyncErrorClearer);
  run.later(() => {
    assert.ok(subject.get('showAsyncError'), "showAsyncError remains unchanged after set");
  });

  return wait();
});
