import run from 'ember-runloop';
import EmberObject from 'ember-object';
import { BadAttemptHandlerMixin } from 'web-client/services/bits-room';
import { module, test } from 'qunit';
import wait from 'ember-test-helpers/wait';
import { TIMINGS } from 'web-client/utilities/bits/constants-config';

module('Unit | Mixin | bad attempt handler mixin', {
  beforeEach() {
    TIMINGS.ERROR_DISPLAY_TIMEOUT = 0; // Don't wait 5 seconds for this test
    this.BadAttemptHandlerMixinObject = EmberObject.extend(BadAttemptHandlerMixin);
  }
});

test('Unsets itself', function (assert) {
  assert.expect(2);
  let subject = this.BadAttemptHandlerMixinObject.create();
  subject.set('isBadCheerAttempt', true);
  assert.ok(subject.get('isBadCheerAttempt'), "isBadCheerAttempt is true");
  run.later(() => {
    assert.ok(!subject.get('isBadCheerAttempt'), "isBadCheerAttempt is set to false afterwards");
  });
  return wait();
});

test('Teardown works', function (assert) {
  assert.expect(1);
  let subject = this.BadAttemptHandlerMixinObject.create();
  subject.set('isBadCheerAttempt', true);
  run.cancel(subject._badAttemptClearer);
  run.later(() => {
    assert.ok(subject.get('isBadCheerAttempt'), "isBadCheerAttempt remains unchanged after set");
  });

  return wait();
});
