import CanonicalUrlRouteMixin from 'web-client/mixins/canonical-url-route';
import Service from 'ember-service';
import { moduleFor, test } from 'ember-qunit';
import EObject from 'ember-object';
import Ember from 'ember';

const { ActionHandler } = Ember;
const routingServiceStub = Service.extend({
  models: [],
  generateURL(routeName) {
    let routePath = `/${routeName}`;
    let model = this.get('models.firstObject');

    if (model) {
      routePath += `/${model.id}`;
    }

    return routePath;
  }
});

moduleFor('mixin:canonical-url-route', {
  needs: [
    'service:head-data',
    'service:experiments',
    'service:ajax',
    'service:vod-resume-watching',
    'service:tracking',
    'service:recs-holdout'
  ],
  beforeEach() {
    this.BaseObject = EObject.extend(ActionHandler, CanonicalUrlRouteMixin);
    this.setupRegistry();
  },
  setupRegistry() {
    this.registry.register('test:subject', this.BaseObject);
    this.register('service:-routing', routingServiceStub);
  },
  subject(properties) {
    let subject = this.container.lookup('test:subject');
    subject.setProperties(properties);
    return subject;
  },
  populateRoutingService(models) {
    this.container.lookup('service:-routing').setProperties({
      models: models
    });
  }
});

test('Sets Canonical URL on afterModel', function (assert) {
  assert.expect(1);

  let subject = this.subject({routeName: 'channel'});
  this.populateRoutingService([{id: 'testuser'}]);
  subject.send('updateCanonicalUrl');
  assert.equal(subject.get('headData.canonicalUrl'), 'https://www.twitch.tv/channel/testuser');
});

test('Supports setCanonicalUrl override', function (assert) {
  assert.expect(1);

  let subject = this.subject({
    routeName: 'channel',
    buildCanonicalUrl() {
      return `/${this.routeName}`;
    }
  });

  subject.send('updateCanonicalUrl');
  assert.equal(subject.get('headData.canonicalUrl'), 'https://www.twitch.tv/channel');
});
