import { module, test } from 'qunit';
import Ember from 'ember';
import CachedMixin from 'web-client/models/core/mixins/static/cached';

const { Object: EmberObject } = Ember;

module('CachedMixin', {
  setup() {
    let Model = EmberObject.extend({});
    Model.reopenClass(CachedMixin, {});
    this.mixin = Model.extend({});
  }
});

test('can create mixin', function (assert) {
  assert.ok(this.mixin);
});

test('cannot create using the create method', function (assert) {
  let resource = this.mixin.create('user');
  assert.equal(undefined, resource);
});

test('can create with the find method', function (assert) {
  let resource = this.mixin.find({id: 'llama'});
  assert.ok(resource);
  assert.equal(resource.id, 'llama');
});

test('find returns the same thing from cache if the options are the same', function (assert) {
  let resource = this.mixin.find({id: 'Pikachu'});
  let resource2 = this.mixin.find({id: 'Pikachu'});
  assert.strictEqual(resource, resource2);
});

test('find creates a new resource if the ids are different', function (assert) {
  let resource = this.mixin.find({id: 'Pikachu'});
  let resource2 = this.mixin.find({id: 'Squirtle'});
  assert.notEqual(resource, resource2);
});

test('find creates a new resource if the ids are same but other properties are not', function (assert) {
  let resource = this.mixin.find({id: 'Pikachu'});
  let resource2 = this.mixin.find({id: 'Pikachu', owner: 'Ash'});
  assert.notEqual(resource, resource2);
});

test('find returns a different resource if the model is different', function (assert) {
  let Model2 = EmberObject.extend({});
  Model2.reopenClass(CachedMixin, {});
  let mixin2 = Model2.extend({});
  let resource = this.mixin.find({id: 'Pikachu'});
  let resource2 = mixin2.find({id: 'Pikachu'});
  assert.notEqual(resource, resource2);
});

test('find returns a resource with the proper id', function (assert) {
  let resource = this.mixin.find({id: 'Pikachu'});
  assert.equal(resource.get('id'), 'Pikachu');
});
