import run from 'ember-runloop';
import EmberObject from 'ember-object';
import { DelayedSendHandlerMixin } from 'web-client/services/bits-room';
import { module, test } from 'qunit';
import wait from 'ember-test-helpers/wait';
import { TIMINGS } from 'web-client/utilities/bits/constants-config';

let DelayedSendHandlerMixinObject = EmberObject.extend(DelayedSendHandlerMixin);
let subject;
TIMINGS.UNDO_PROMPT_DURATION = 0; // Don't wait 5s for tests

module('Unit | Mixin | delayed send handler', {
  beforeEach() {
    subject = createWithDefaults();
  }
});

function createWithDefaults() {
  return DelayedSendHandlerMixinObject.create({
    messageToSend: 'test message',
    _cheer() {}
  });
}

test('Unsets itself', function (assert) {
  assert.expect(2);

  subject.set('delayedBitsSend', true);
  assert.ok(subject.get('delayedBitsSend'), "delayedBitsSend is true");
  run.later(() => {
    assert.ok(!subject.get('delayedBitsSend'), "delayedBitsSend is set to false afterwards");
  });
  return wait();
});

test('Teardown works', function (assert) {
  assert.expect(1);

  subject.set('delayedBitsSend', true);
  run.cancel(subject._delayedSendClearer);
  run.later(() => {
    assert.ok(subject.get('delayedBitsSend'), "delayedBitsSend remains unchanged after set");
  });

  return wait();
});
