import { moduleFor } from 'ember-qunit';
import test from 'ember-sinon-qunit/test-support/test';
import EmberObject from 'ember-object';
import Service from 'ember-service';
import { send } from 'ember-metal/events';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';

const COMPONENT_NAME = 'foo-bar';

const interactivityStub = Service.extend({
  reportInteractive() {},

  reportNonInteractive() {}
});

moduleFor('mixin:interactivity-deferred-component', 'Unit | Mixin | interactivity-deferred-component', {
  beforeEach() {
    this.BaseObject = EmberObject.extend(InteractivityDeferredComponent, {
      toString() {
        return `<web-client@component:${COMPONENT_NAME}::ember1234>`;
      }
    });
    this.registry.register('test:subject', this.BaseObject);
    this.register('service:interactivity', interactivityStub);
  },

  subject(properties = {}) {
    let subject = this.container.lookup('test:subject');
    subject.setProperties(properties);
    return subject;
  }
});

test('latencyReportingId', function (assert) {
  let id = this.subject().get('latencyReportingId');

  assert.equal(id, COMPONENT_NAME, 'latencyReportingId pulls the component name from toString');
});

test('reportInteractive', function (assert) {
  let subject = this.subject();
  let interactivity = subject.get('interactivity');

  let stub = this.stub(interactivity, 'reportInteractive');

  subject.reportInteractive();

  assert.ok(stub.calledOnce, 'reportInteractive was called on the interactivity service');
  assert.ok(stub.calledWithExactly(COMPONENT_NAME), 'latencyReportingId was sent to interactivity service');
});

test('reportNonInteractive', function (assert) {
  let subject = this.subject();
  let interactivity = subject.get('interactivity');

  let stub = this.stub(interactivity, 'reportNonInteractive');

  subject.reportNonInteractive();

  assert.ok(stub.calledOnce, 'reportNonInteractive was called on the interactivity service');
  assert.ok(stub.calledWithExactly(COMPONENT_NAME), 'latencyReportingId was sent to interactivity service');
});

test('reportNonInteractive - on willDestroyElement', function (assert) {
  let subject = this.subject();
  let interactivity = subject.get('interactivity');

  let stub = this.stub(interactivity, 'reportNonInteractive');

  send(subject, 'willDestroyElement');

  assert.ok(stub.calledOnce, 'reportNonInteractive was called on the interactivity service');
  assert.ok(stub.calledWithExactly(COMPONENT_NAME), 'latencyReportingId was sent to interactivity service');
});
