import Ember from 'ember';
import TimerMixin from '../../../mixins/timer';
import { module, test } from 'qunit';

const { Object: EmberObject, Evented } = Ember;

let subject, timerObject;

module('Unit | Mixin | Timer', {
  beforeEach() {
    timerObject = EmberObject.extend(Evented, TimerMixin);
    subject = timerObject.create();
  },
  afterEach() {
    timerObject = null;
    subject = null;
  }
});

test('on `activate` should start the timer', function (assert) {
  assert.expect(1);

  subject.startTimer = function () {
    assert.ok(true, 'startTimer was called');
  };

  subject.trigger('activate');

});

test('on `deactivate` should stop the timer', function (assert) {
  assert.expect(1);

  subject.stopTimer = function () {
    assert.ok(true, 'stopTimer was called');
  };

  subject.trigger('deactivate');
});
