import { module, test } from 'qunit';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import Ember from 'ember';
const { merge } = Ember;

module('deprecated-game', 'Unit | Model | deprecated game');

function gameData(attrs) {
  return merge({
    "name": "League of Legends",
    "popularity": 1853,
    "id": "League of Legends"
  }, attrs);
}

test('creating a game from an un-namespaced response (search request)', function(assert) {
  let game = DeprecatedGameModel.create(gameData());

  assert.deepEqual([game.name, game.popularity], ["League of Legends", 1853]);
});

test('creating a game from a namespaced response (follow request)', function(assert) {
  let game = DeprecatedGameModel.create({
    game: gameData(),
    viewers: 1,
    channels: 2,
    arbitraryAttribute: 'something'
  });

  assert.deepEqual(game.getProperties('id', 'name', 'popularity', 'viewerCount', 'channelCount', 'arbitraryAttribute'), {
    id: "League of Legends",
    name: "League of Legends",
    popularity: 1853,
    viewerCount: 1,
    channelCount: 2,
    arbitraryAttribute: 'something'
  }, "Game has all properties");
});

test('renaming attributes', function(assert) {
  let game = DeprecatedGameModel.create(gameData({
    'viewers': 1,
    'channels': 2
  }));

  assert.equal(game.get('viewerCount'), 1, "renames viewers to viewerCount");
  assert.equal(game.get('channelCount'), 2, "renames channels to channelCount");
});

test('providing an id when it is missing', function(assert) {
  let payload = gameData({ name: 'soon-to-be-id' });
  delete payload.id;

  let game = DeprecatedGameModel.create(payload);

  assert.equal(game.get('id'), 'soon-to-be-id', "uses the name as the ID");
});

test('adding a URL to the game', function(assert) {
  let payload = gameData();
  let game = DeprecatedGameModel.create(payload);

  assert.equal(game.get('url'), '/directory/game/League%20of%20Legends', "uses the name as the ID");
});
