import { moduleForModel, test } from 'ember-qunit';
import moment from 'moment';

moduleForModel('game-detail', 'Unit | Model | game detail', {
  // Specify the other units that are required for this test.
  needs: []
});

test('it exists', function(assert) {
  let model = this.subject();
  assert.ok(!!model);
});

test('isForSale when before end date', function(assert) {
  let model = this.subject({
    product: {
      release_end_date: moment().add(1, 'minute').toISOString()
    }
  });
  assert.ok(model.get('isForSale'));
});

test('not isForSale when after end', function(assert) {
  let model = this.subject({
    product: {
      release_end_date: moment().subtract(1, 'minute').toISOString()
    }
  });
  assert.ok(!model.get('isForSale'));
});
