import { moduleForModel, test } from 'ember-qunit';
import run from 'ember-runloop';

moduleForModel('video', 'Unit | Model | video', {
  // Specify the other units that are required for this test.
  needs: ['model:channel']
});

test('it exists', function(assert) {
  let model = this.subject();
  // let store = this.store();
  assert.ok(!!model);
});

test('isPublished computed property', function(assert) {
  assert.expect(2);

  let model = this.subject({
    viewable: 'public'
  });

  assert.ok(model.get('isPublished'), 'considered published if viewable is public');
  run(() => {
    model.set('viewable', 'garbagedata');
  });
  run.next(() => {
    assert.ok(!model.get('isPublished'), 'unpublished if viewable is anything but public');
  });
});

test('recordedDate computed property', function(assert){
  assert.expect(3);

  let dateOne = new Date(2016, 1, 1);
  let dateTwo = new Date(2016, 2, 1);

  let model = this.subject({
    publishedAt: dateOne
  });

  assert.equal(dateOne, model.get('recordedDate'), 'works with just publishedAt');
  run(() => {
    model.set('publishedAt', undefined);
    model.set('createdAt', dateTwo);
  });
  run.next(() => {
    assert.equal(model.get('createdAt'), dateTwo, 'works with just createdAt');
  });

  run.next(() => {
    model.set('createdAt', undefined);
  });
  run.next(() => {
    assert.ok(!model.get('recordedDate'), 'returns falsy when neither are defined');
  });

});

test('thumbnailPreviewUrl computed property', function(assert) {
  assert.expect(2);

  let thumbnails = [{url: 'thumbnailUrl'}];
  let preview = {medium: "previewUrl"};

  let model = this.subject({
    thumbnails,
    thumbnailIndex: 0,
    preview
  });

  assert.equal(model.get('thumbnailPreviewUrl'), 'thumbnailUrl', 'uses thumbnails when thumbnailIndex defined');

  run(() => {
    model.set('thumbnailIndex', undefined);
  });
  run.next(() => {
    assert.equal(model.get('thumbnailPreviewUrl'), 'previewUrl', 'uses preview if no thumbnailIndex');
  });
});


