import moduleFor from 'web-client/tests/helpers/module-for';
import { test } from 'qunit';
import MockPersistentPlayer from 'web-client/tests/helpers/mock-persistent-player-service';

moduleFor('route:full-size-player-route', 'Unit | Route | FullSizePlayerRoute', {
  beforeEach() {
    this.player = this.subject({ persistentPlayer: MockPersistentPlayer.create() });
  }
});

test('on `activate` should set the canBeFullSize attr of the player to true', function(assert) {
  this.player.trigger('activate');
  assert.ok(this.player.get('persistentPlayer.canBeFullSize'));
});

test('on `deactivate` should set the canBeFullSize attr of the player to false', function(assert) {
  this.player.trigger('deactivate');
  assert.notOk(this.player.get('persistentPlayer.canBeFullSize'));
});

test('on `deactivate` should unlock the player from full size mode', function(assert) {
  this.player.trigger('deactivate');
  assert.notOk(this.player.get('persistentPlayer.lockedInFullSize'));
});

test('`shrinkPlayer` action should not propagate if the the player is already mini', function(assert) {
  this.player.get('persistentPlayer').setMini(true);
  let didPropagate = this.player.send('shrinkPlayer');
  assert.notOk(didPropagate);
});

test('`shrinkPlayer` action should not propagate if the the player is locked in full size', function(assert) {
  this.player.set('persistentPlayer.lockedInFullSize', true);
  let didPropagate = this.player.send('shrinkPlayer');
  assert.notOk(didPropagate);
});

test('`shrinkPlayer` action should propagate if the player is full size and not locked', function(assert) {
  this.player.set('persistentPlayer.lockedInFullSize', false);
  this.player.get('persistentPlayer').setMini(false);

  let didPropagate = this.player.send('shrinkPlayer');
  assert.ok(didPropagate);
});

test('`anchorPlayer` action should unlock the player from full size', function(assert) {
  this.player.send('anchorPlayer');
  assert.notOk(this.player.get('persistentPlayer.lockedInFullSize'));
});

test('`anchorPlayer` action should not propagate if the player is already full size', function(assert) {
  this.player.get('persistentPlayer').setMini(false);
  let didPropagate = this.player.send('anchorPlayer');
  assert.notOk(didPropagate);
});

test('`anchorPlayer` action should propagate if the player is mini', function(assert) {
  this.player.get('persistentPlayer').setMini(true);
  let didPropagate = this.player.send('anchorPlayer');
  assert.ok(didPropagate);
});

test('before `showPlayer` propagates', function(assert) {
  this.player.get('persistentPlayer').setMini(true);
  let didPropagate = this.player.send('showPlayer');
  assert.ok(didPropagate);
  assert.notOk(this.player.get('persistentPlayer.isMini'), 'should set isMini to false');
});

