import { moduleForModel, test } from 'ember-qunit';
import run from 'ember-runloop';

moduleForModel('friends-list-user', 'serializer:friends-list-user', {
  integration: true,

  beforeEach() {
    this.serializer = this.store().serializerFor('friends-list-user');
  }
});

test('normalize users', function(assert) {
  let model;
  let userId = 123456;
  let userCreatedAt = 'tonight';
  let userDisplayName = 'dOoBiX';
  let userName = 'doobix';
  let payload = {
    'users': [
      {
        '_id': userId,
        'created_at': userCreatedAt,
        'display_name': userDisplayName,
        'name': userName
      },
      {
        '_id': '456789',
        'created_at': 'today',
        'display_name': 'XiBoOd',
        'name': 'xibood'
      }
    ]
  };

  run(() => {
    model = this.serializer.normalizeQueryResponse(null, null, payload);
  });

  assert.equal(model.data.length, 2);
  assert.equal(model.data[0].id, userId.toString(), 'has correct id');
  assert.equal(model.data[0].attributes.displayName, userDisplayName, 'has correct display name');
  assert.equal(model.data[0].attributes.login, userName, 'has correct login name');
  assert.equal(model.data[0].attributes.createdAt, userCreatedAt, 'has correct creation date');
});

test('normalize recommended users', function(assert) {
  let model;
  let userId = 123456;
  let userCreatedAt = 'tonight';
  let userDisplayName = 'dOoBiX';
  let userName = 'doobix';
  let reason = 'mod_in_same_channels';
  let source = 'fallback';
  let payload = {
    'recommendations': [
      {
        'user': {
          '_id': userId,
          'created_at': userCreatedAt,
          'display_name': userDisplayName,
          'name': userName
        },
        'reason': reason
      }
    ],
    'source': source
  };

  run(() => {
    model = this.serializer.normalizeQueryResponse(null, null, payload);
  });

  assert.equal(model.data.length, 1);
  assert.equal(model.meta.source, source, 'has correct source');
  assert.equal(model.data[0].id, userId.toString(), 'has correct id');
  assert.equal(model.data[0].attributes.displayName, userDisplayName, 'has correct display name');
  assert.equal(model.data[0].attributes.login, userName, 'has correct login name');
  assert.equal(model.data[0].attributes.createdAt, userCreatedAt, 'has correct creation date');
  assert.equal(model.data[0].attributes.recommendedReason, 'You mod the same channels', 'has correct recommended reason');
});

test('normalize friends', function(assert) {
  let model;
  let userId = 123456;
  let userTimestamp = 123456789;
  let userUpdatedAt = 123456456;
  let userIndex = 1234;
  let userAvailability = 'online';
  let userActivities = {
    'channel_display_name': 'Valve',
    'channel_id': '978654',
    'channel_login': 'valve',
    'game': 'Counter-Strike',
    'type': 'watching'
  };
  let payload = {
    'data': [
      {
        'activities': [userActivities],
        'availability': userAvailability,
        'index': userIndex,
        'timestamp': userTimestamp,
        'updated_at': userUpdatedAt,
        'user_id': userId
      },
      {
        'activities': {},
        'availability': 'offline',
        'index': 2345,
        'timestamp': 123123111,
        'updated_at': 123123000,
        'user_id': 456789
      }
    ]
  };
  this.serializer.set('session', {'userData': {'id': userId}});

  run(() => {
    model = this.serializer.normalizeQueryResponse(null, null, payload);
  });

  assert.equal(model.data.length, 2);
  assert.equal(model.data[0].id, userId.toString(), 'has correct id');
  assert.equal(model.data[0].attributes.availability, userAvailability, 'has correct availability');
  assert.deepEqual(model.data[0].attributes.activities[0], userActivities, 'has correct activities');
});
