import { moduleForModel, test } from 'ember-qunit';
import run from 'ember-runloop';

moduleForModel('game-detail', 'Unit | Serializer | game detail', {
  integration: true,

  beforeEach() {
    this.serializer = this.store().serializerFor('game-detail');
  }
});

test('serializing a single query response', function(assert) {
  const ASIN = 'TESTASIN';
  const PRICE = '10';
  const GENRES = 'test genres';

  let payload = {
    "action_details": {
    },
    "premium_eligibility": {
    },
    "product": {
      "asin": ASIN,
      "price": {
        "price": PRICE
      },
      "genres": [GENRES]
    },
    "user_entitlement": {
    }
  };

  let hash = this.serializer.normalizeQueryRecordResponse(this.store(), 'game-detail', payload, null);

  let model;
  run(() => {
    this.serializer.pushPayload(this.store(), hash);
    model = this.store().peekRecord('game-detail', ASIN);
  });

  assert.equal(model.get('product.asin'), ASIN, 'get test asin');
  assert.equal(model.get('product.price.price'), PRICE, 'has price');
  assert.equal(model.get('product.genres').length, 1, 'has genres');
});
