import run from 'ember-runloop';
import { test } from 'ember-qunit';
import moduleForModel from 'web-client/tests/helpers/module-for-model';

moduleForModel('offer', 'Unit | Serializer | offer', {
  integration: true,

  beforeEach() {
    this.serializer = this.store().serializerFor('offer');
    this.modelClass = this.store().modelFor('offer');
  }
});

test('serializing an array response', function(assert) {
  let model;
  let payload = {
    "offers": [{
        "applicableGame": "TheGame",
        "assets": [{
            "assetType": "ICON",
            "location": "https://images-na.ssl-meet_.png",
            "location2x": null,
            "mediaType": "IMAGE"
        }, {
            "assetType": "THUMBNAIL",
            "location": "https://images-na.ssl-meetmeet_.png",
            "location2x": null,
            "mediaType": "IMAGE"
        }, {
            "assetType": "DETAIL",
            "location": "https://images-na.ssl-dave_.png",
            "location2x": null,
            "mediaType": "IMAGE"
        }],
        "contentCategories": ["Full Game"],
        "contentClaimInstruction": "Click 'Claim' and you will automatically be entitled to play.",
        "endTime": "2016-07-01T23:00:00Z",
        "offerDescription": "The description of the game.",
        "offerId": "1",
        "offerTitle": "The Title",
        "publisherName": "Bungie",
        "startTime": "2016-06-27T22:48:12Z"
    }]
  };

  let hash = this.serializer.normalizeArrayResponse(this.store(), this.modelClass, payload, null, 'findAll');
  run(() => {
    this.serializer.pushPayload(this.store(), hash);
    model = this.store().peekRecord('offer', '1');
  });

  assert.equal(model.get('offerTitle'), 'The Title');
  assert.equal(model.get('icon.assetType'), 'ICON');
  assert.equal(model.get('thumbnail.assetType'),'THUMBNAIL');
});
