import { moduleForModel, test } from 'ember-qunit';
import { deserializeRecentlyWatchedStreams, deserializeRecentlyWatchedStreamsIncluded } from 'web-client/serializers/recently-watched-stream';

moduleForModel('recently-watched-stream', 'Unit | Serializer | serializer:recently-watched-stream',  {
  integration: true,

  beforeEach() {
    this.serializer = this.store().serializerFor('recently-watched-stream');
  }
});

test('serializing a single queryRecord response', function(assert) {
  let model;
  let channel1Name = '3564';
  let channel2Name = '75674';
  let payload = {
    recently_watched_streams: [{
        channel: {
          name: channel1Name
        }
      },
      {
        channel: {
          name: channel2Name
        }
      }]
  };

  model = deserializeRecentlyWatchedStreams(payload.recently_watched_streams);
  let modelStreams = model.relationships.streams.data;

  assert.equal(modelStreams.length, 2, 'has two stream relationship');
  assert.equal(modelStreams[0].id, channel1Name, 'has correct stream relationship');
  assert.equal(modelStreams[1].id, channel2Name, 'has correct stream relationship');
});

test('serializing included for a single queryRecord response', function(assert) {
  let model;
  let channel1Name = '3564';
  let channel2Name = '75674';
  let payload = {
    recently_watched_streams: [{
        channel: {
          name: channel1Name
        }
      },
      {
        channel: {
          name: channel2Name
        }
      }]
  };

  model = deserializeRecentlyWatchedStreamsIncluded(payload.recently_watched_streams);

  assert.equal(model.length, 2, 'has two channel includes and a stream include');
});
