import { moduleForModel, test } from 'ember-qunit';
import run from 'ember-runloop';
import { deserializeRecommendedStreams, deserializeRecommendedStreamsIncluded } from 'web-client/serializers/recommended-stream';

moduleForModel('recommended-stream', 'serializer:recommended-stream', {
  integration: true,

  beforeEach() {
    this.serializer = this.store().serializerFor('recommended-stream');
  }
});

test('serializing a single query response', function(assert) {
  let model;
  let channelId = 10;
  let channelName = '3564';
  let channel2Name = '75674';
  let channel3Name = 'dfgklhj';
  let payload = {
    "recommended_streams": [{
      "channel": {
        "_id": channelId,
        "name": channelName
      },
      "streams": [{
        "channel": {
          "name": channel2Name
        }
      },
      {
        "channel": {
          "name": channel3Name
        }
      }]
    }]
  };

  run(() => {
    model = deserializeRecommendedStreams(payload.recommended_streams);
  });

  assert.equal(model.length, 1);
  assert.equal(model[0].id, channelName, 'correct id');
  assert.equal(model[0].relationships.channel.data.id, channelName, 'has correct channel relationship');
  assert.equal(model[0].relationships.streams.data.length, 2, 'has two stream relationship');
  assert.equal(model[0].relationships.streams.data[0].id, channel2Name, 'has correct stream relationship');
  assert.equal(model[0].relationships.streams.data[1].id, channel3Name, 'has correct stream relationship');
});

test('serializing included for a single query response', function(assert) {
  let model;
  let channelId = 10;
  let payload = {
    "recommended_streams": [{
      "channel": {
        "_id": channelId,
        "name": "test"
      },
      "streams": [{
        "viewers": 1234,
        "channel": {
          "name": "test2"
        }
      }]
    }]
  };

  run(() => {
    model = deserializeRecommendedStreamsIncluded(payload.recommended_streams);
  });

  assert.equal(model.length, 3, 'has two channel includes and a stream include');
});
