import { moduleFor, test } from 'ember-qunit';

moduleFor('service:ads', {
  // Specify the other units that are required for this test.
  // needs: ['service:foo']
});

test('dismiss action', function(assert) {
  assert.expect(3);

  let service = this.subject({
    enabled: true,
    layout: {
      wideEnoughForAds: true
    }
  });

  assert.ok(service.get('visible'), 'service starts visible when enabled and wide enough');

  service.dismiss();
  assert.ok(service.get('dismissed'), 'dismissed set to true');
  assert.notOk(service.get('visible'), 'dismissed ads are not visible');
});
