import Ember from 'ember';
import { moduleFor, test, skip } from 'ember-qunit';
import wait from 'ember-test-helpers/wait';
import MockGeoService, {
  RECEIVED_LANGUAGE
} from 'web-client/tests/helpers/mock-geo-service';

const { RSVP } = Ember;
const STRINGS = [
  { key: 'common_greeting', value: 'hello' },
  { key: 'common_farewell', value: 'bye' }
];

function mockRequestBitsStrings() {
  return RSVP.resolve({'strings': STRINGS});
}

moduleFor('service:bits-strings', 'Unit | Service | bits strings', {
  needs: [
    'service:api',
    'service:geo'
  ],

  beforeEach() {
    this.register('service:geo', MockGeoService);
  }
});

skip('getString - FAILING INTERMITTENTLY (NEEDS MIRAGE)', function (assert) {
  let service = this.subject();

  assert.equal(service.getString('common_greeting'), '', 'return blank string if string doesnt exist and no default');
  assert.equal(service.getString('common_greeting', 'hi'), 'hi', 'return default string if string doesnt exist');

  service.receivedLanguage = RECEIVED_LANGUAGE;
  service._strings[RECEIVED_LANGUAGE] = service._transformStringResponse(STRINGS);

  assert.equal(service.getString('common_greeting'), 'hello', 'string value is returned');
});

test('_loadStrings', function (assert) {
  assert.expect(3);
  let service = this.subject();

  service._requestBitsStrings = mockRequestBitsStrings;

  return wait().then(() => {
    assert.ok(service.isLoaded, 'isLoaded is set');
    assert.equal(service.receivedLanguage, RECEIVED_LANGUAGE, 'language is set');
    assert.ok(service._strings.hasOwnProperty(RECEIVED_LANGUAGE), 'strings are stored');
  });
});

test('_transformStringResponse', function (assert) {
  let service = this.subject();
  service._requestBitsStrings = mockRequestBitsStrings;

  let stringMap = service._transformStringResponse(STRINGS);

  assert.equal(stringMap['common_greeting'], 'hello');
  assert.equal(stringMap['common_farewell'], 'bye');
});
