import { moduleFor, test } from 'ember-qunit';

moduleFor('service:component-outlet');

test('it updates outlets when render is called', function (assert) {
  let service = this.subject();
  let outlet = 'sidebar';
  let sourceTemplateName = 'jeremy';
  let componentName = 'nav';
  service.render(componentName, {sourceTemplateName, outlet});
  assert.deepEqual(
    service.get(`outlets.${sourceTemplateName}${service.DELIMETER}${outlet}`),
    {componentName}
  );
});

test('it updates outlets when render is called with model', function (assert) {
  let service = this.subject();
  let outlet = 'sidebar';
  let sourceTemplateName = 'jeremy';
  let componentName = 'nav';
  let model = {};
  service.render(componentName, {sourceTemplateName, outlet, model});
  assert.deepEqual(
    service.get(`outlets.${sourceTemplateName}${service.DELIMETER}${outlet}`),
    {componentName, model}
  );
});

test('it disconnects outlets', function (assert) {
  let service = this.subject();
  let outlet = 'sidebar';
  let sourceTemplateName = 'lucy';
  let componentName = 'nav';
  service.render(componentName, {sourceTemplateName, outlet});
  assert.deepEqual(
    service.get(`outlets.${sourceTemplateName}${service.DELIMETER}${outlet}`),
    {componentName},
    'precond - outlet is rendered'
  );

  service.disconnect({sourceTemplateName, outlet});
  assert.equal(
    service.get(`outlets.${sourceTemplateName}${service.DELIMETER}${outlet}`),
    null
  );
});
