import { moduleFor, test } from 'ember-qunit';
import run from 'ember-runloop';
import sinon from 'sinon';

let service;
let documentAddEventListenerStub;

moduleFor('service:document-visibility', 'Unit | Service | document visibility', {
  beforeEach() {
    documentAddEventListenerStub = sinon.stub(document, 'addEventListener');
    service = this.subject();
  },
  afterEach() {
    documentAddEventListenerStub.restore();
    run(service, 'destroy');
  }
});

test('it should listen to visibilitychange events', function(assert) {
  assert.ok(documentAddEventListenerStub.calledOnce);
  assert.equal(documentAddEventListenerStub.args[0][0], 'visibilitychange');
});

test('it should handle visibility change', function(assert) {
  const handleDocumentVisibilityChangeStub = sinon.stub(service, '_handleDocumentVisibilityChange');
  const handler = documentAddEventListenerStub.args[0][1];
  handler();
	assert.ok(handleDocumentVisibilityChangeStub.calledOnce);
});
