import EmberObject from 'ember-object';
import RSVP from 'rsvp';
import { moduleFor, test } from 'ember-qunit';

let embedService;
let embedURL = 'https://clips.twitch.tv/odpixel/BusyNewtNotLikeThis';
let MockApiRequest = EmberObject.extend({
  authRequest() {
    return RSVP.resolve({request_url: 'twitch.tv'});
  }
});

moduleFor('service:embeds', 'Unit | Service | embeds', {
  beforeEach() {
    embedService = this.subject({
      api: new MockApiRequest()
    });
    embedService.embeds = [];
  }
});

test('it adds the promise to the embeds array', function(assert) {
  assert.expect(2);
  assert.notOk(embedService.embeds[embedURL], 'the url has not been requested yet');
  embedService.getEmbed(embedURL);
  assert.ok(embedService.embeds[embedURL], 'service adds the embed promise to the embeds array');
});

test('it returns the cached promise when a duplicate request is made', function(assert) {
  assert.expect(2);
  embedService.getEmbed(embedURL);
  let dupRequestPromise = embedService.getEmbed(embedURL);
  assert.ok(embedService.embeds[embedURL], 'the promise response has been cached');
  assert.equal(dupRequestPromise, embedService.embeds[embedURL], 'the cached response was returned');
});
