import EmberObject from 'ember-object';
import { moduleFor, test } from 'ember-qunit';
import run from 'ember-runloop';
import wait from 'ember-test-helpers/wait';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';
import sinon from 'sinon';

let service, feed;


moduleFor('service:feeds', 'Unit | Service | feeds', {
  needs: [
    'service:globals',
    'service:session',
    'service:pubsub',
    'service:api'
  ],
  beforeEach() {
    setupMirage(this);
    service = this.subject();

    feed = EmberObject.create({
      id: 'lirik',
      topic: 'lirik-1231238798',
      posts: []
    });
  },
  afterEach() {
    run(service, 'destroy');
    teardownMirage(this);
  }
});

test('#bindLiveFeed - should fetch channel permissions after binding to a feed', function (assert) {
  let done = assert.async();
  assert.expect(1);

  let getChannelPermissionsStub = sinon.stub(service, '_getChannelPermissions');

  service.bindLiveFeed(feed);

  return wait().then(() => {
    assert.ok(getChannelPermissionsStub.calledOnce);
    done();
  });
});

test('#_getChannelPermissions - should fetch feed permissions from the permissions api endpoint', function (assert) {
  let done = assert.async();
  assert.expect(1);

  service._getChannelPermissions('lirik').then((permissionsContext) => {
    assert.deepEqual(permissionsContext, {
      can_delete: true,
      can_moderate: true,
      can_reply: false
    });
    done();
  });
});
