import { moduleFor, test } from 'ember-qunit';
import {
  setup as setupMirage,
  teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';

let service;

moduleFor('service:game-settings', 'Unit | Service | game-settings', {
  needs: [
    'service:api',
    'service:session'
  ],
  beforeEach() {
    setupMirage(this);
    service = this.subject();
  },
  afterEach() {
    teardownMirage(this);
  }
});

test('getGameSettings hits endpoint', function (assert) {
  let done = assert.async();
  assert.expect(1);

  service.getGameSettings('test game').then((detailsEnabled) => {
    assert.equal(detailsEnabled, true, 'return true setup in mirage');
    done();
  });
});

test('getGameSettings call deduplicates when called rapidly.', function (assert) {
  assert.expect(1);

  let promise1 = service.getGameSettings('test game');
  let promise2 = service.getGameSettings('test game');
  assert.equal(promise1, promise2, "Same promise is returned for duplicate requests");
});


test('getGameSettings call doesnt dedupe when no call in-flight', function (assert) {
  assert.expect(1);

  let promise1 = service.getGameSettings('test game');
  return promise1.then(() => {
    let promise2 = service.getGameSettings('test game');
    assert.notEqual(promise1, promise2, "different promise is returned after promise resolves");
  });
});
