import { moduleFor, test } from 'ember-qunit';

moduleFor('service:player-registry', 'Unit | Service | player registry', {
  beforeEach() {
    this.fakePlayerObj1 = {player: true, classNames: ['js-twitch-player-2']};
    this.fakePlayerObj2 = {player: true, classNames: ['js-twitch-player-2']};
  },
  afterEach() {
    this.subject().clear();
  }
});

test("it exists", function(assert) {
  assert.expect(1);
  let service = this.subject();
  assert.ok(service);
});

test("the registry is empty by default", function(assert) {
  assert.expect(1);
  let service = this.subject();
  assert.equal(service.players.length, 0, "the registry is empty by default");
});

test("you can add a player", function(assert) {
  assert.expect(1);
  let service = this.subject();
  let fakePlayerObj = {player: true, classNames: ['js-twitch-player-2']};
  service.add(fakePlayerObj);
  assert.equal(service.players.length, 1, "#add() adds an item to the registry");
});

test("you can remove an added player", function(assert) {
  assert.expect(2);
  let service = this.subject();
  service.add(this.fakePlayerObj1);
  service.add(this.fakePlayerObj2);
  assert.equal(service.players.length, 2, "#add() adds items to the registry");
  service.remove(this.fakePlayerObj2);
  assert.equal(service.players.length, 1, "#remove() removes an added item from the registry");
});

test("you can clear the registry", function(assert) {
  assert.expect(2);
  let service = this.subject();
  service.add(this.fakePlayerObj1);
  service.add(this.fakePlayerObj2);
  assert.equal(service.players.length, 2, "#add() adds items to the registry");
  service.clear();
  assert.equal(service.players.length, 0, "#clear() clears the registry");
});
