import moduleFor from 'web-client/tests/helpers/module-for';
import { test } from 'ember-qunit';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import MockTrackingService from 'web-client/tests/helpers/mock-tracking-service';

moduleFor('service:recs-holdout', 'Unit | Service | recs-holdout', {
  BeforeEach() {
    this.inject.service('crypto');
    this.register('service:session', AuthenticatedSession);
    this.register('service:tracking', MockTrackingService);
  }
});

test("_calculateRecHoldoutSplit correctly converts a string to float between 0 and 1", function(assert) {
  assert.expect(1);

  let testUserId = "12345";
  let expectedHashFloat = 0.16865319639088516;

  let service = this.subject();

  assert.equal(service._calculateRecHoldoutSplit(testUserId), expectedHashFloat);
});
