import { moduleFor, test } from 'ember-qunit';
import { timerDuration, changeTimerDuration } from 'web-client/services/timer';

let timer;
let originalTimerDuration = timerDuration;
let testDuration = 10;

moduleFor('service:timer', 'Unit | Service | timer', {
  beforeEach() {
    changeTimerDuration(testDuration);
    timer = this.subject();
  },

  afterEach() {
    timer.stop();
    timer = null;
    changeTimerDuration(originalTimerDuration);
  }
});

test('timer triggers the `timesUp` event when time has passed', function (assert) {
  assert.expect(1);

  let done = assert.async();
  let timeWasUp = false;

  timer.on('timesUp', () => {
    timeWasUp = true;
  });

  timer.start();

  setTimeout(() => {
    assert.ok(timeWasUp, '`timeWasUp` event was triggered');
    done();
  }, testDuration + 5);
});

test('timer does not trigger the `timesUp` event when time has not passed', function (assert) {
  assert.expect(1);

  let done = assert.async();
  let timeWasUp = false;

  timer.on('timesUp', () => {
    timeWasUp = true;
  });

  timer.start();

  setTimeout(() => {
    assert.ok(!timeWasUp, '`timeWasUp` event was triggered');
    done();
  }, testDuration - 5);
});
