import { moduleFor, test } from 'ember-qunit';

moduleFor('service:truex-ads', 'Unit | Service | truex ads', {
  beforeEach() {
    this.origTruex = window.truex;
  },

  afterEach() {
    window.truex = this.origTruex;
  }
});

test('isInitialized false', function(assert) {
  window.truex = undefined;
  let service = this.subject();

  assert.strictEqual(service.isInitialized(), false, 'truex not available');
});

test('isInitialized true', function(assert) {
  window.truex = 'hello';
  let service = this.subject();

  assert.strictEqual(service.isInitialized(), true, 'truex service available');
});
