import { moduleFor, test } from 'ember-qunit';
import RSVP from 'rsvp';

moduleFor('service:video-processor', 'Unit | Service | video-processor');

class MockVideo {
  constructor() {
    this.id = 'v1';
    this.videoUpload = new MockVideoUpload();
  }

  get(value) {
    return this[value];
  }

  reload() {}
}

class MockVideoUpload {
  save() { return RSVP.resolve(); }
  set() {}
}

test('starting a video upload', function(assert) {
  assert.expect(1);

  let video = new MockVideo();

  return this.subject().startVideoUpload(video).then(() => {
    assert.equal(
      this.subject().get('unfinalizedVideos')[0],
      video,
      'should track the new video as unfinalized'
    );
  });
});
