import { moduleFor, test } from 'ember-qunit';
import {
  setup as setupMirage, teardown as teardownMirage
} from 'web-client/tests/helpers/setup-mirage-for-integration';

const VOD_ID = '123';
const FORM_DATA = {
    track_appeals: [
      {
        audible_magic_response_id: "7507737",
        reason: 'original_content'
      }, {
        audible_magic_response_id: "7507738",
        reason: 'permission_rights'
      }
    ],
    full_name: 'asdf',
    street_address_1: 'adsf',
    country: 'asdf',
    city: 'asdf'
};

let service;

moduleFor('service:vod-appeals', 'Unit | Service | vod-appeals', {

  needs: [
    'service:api',
    'service:session',
    'service:vod-appeals'
  ],

  beforeEach() {
    setupMirage(this);
    service = this.subject();
  },
  afterEach() {
    teardownMirage(this);
  }
});

test('whem retrieving muted tracks', function (assert) {
  assert.expect(1);

  return service.getMutedTracks(VOD_ID).then((mutedTracks) => {
    assert.deepEqual(mutedTracks, [
      {
        id: VOD_ID,
        title: 'We Will Rock You (1993 Remastered Version)',
        performer: 'Queen',
        offset: 0,
        duration: 180,
        is_muted: true,
        track_appeal: {
          status: 'pending',
          reason: 'permission_rights'
        }
      }
    ], 'will transform object response into array');
  });
});

test('when retrieving vod appeals', function (assert) {
  assert.expect(1);

  return service.getVodAppeal(VOD_ID).then((vodAppeal) => {
    assert.deepEqual(vodAppeal,
      {
        vod_id: VOD_ID,
        is_muted: true,
        can_create_appeal: true,
        can_view_appeal: false,
        has_pending_appeal: false
      }, 'will call getVodAppeals to hit API and transform response'
    );
  });
});

test('when creating a vod appeal', function (assert) {
  assert.expect(1);

  return service.createAppeal(VOD_ID, FORM_DATA).then((createAppealResult) => {
    assert.deepEqual(createAppealResult, {ok: true}, 'appeal is stringified and sent to api');
  });
});
