import { moduleFor, test } from 'ember-qunit';

moduleFor('service:vod-coviews', {
});

test("_enforceMaxChannelVariety enforces 2 channels", function(assert) { 
  assert.expect(6);

  let vods = [
    {id: 1, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 3, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 4, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 6, channel: {name: 'chirashii'}, game: 'overwatch'},
    {id: 7, channel: {name: 'chirashii'}, game: 'overwatch'}
  ];

  let vodCoviews = this.subject({
    vods: vods
  });

  let have = vodCoviews.get('recommendedVods');
  let want = [
    {id: 1, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 3, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 6, channel: {name: 'chirashii'}, game: 'overwatch'},
    {id: 7, channel: {name: 'chirashii'}, game: 'overwatch'},
    {id: 4, channel: {name: 'charishaxd'}, game: 'league of legends'}
  ];

  have.forEach((vod, index) => {
    assert.deepEqual(have[index], want[index], "Prioritizing max 2 vods per channel");
  });

  assert.equal(vodCoviews.get('forcedVarietyMaxChannelsBoundary'), 4);
});

