import { module, test } from 'qunit';
import Component from 'ember-component';
import Controller from 'ember-controller';
import Service from 'ember-service';
import Route from 'ember-route';
import Mixin from 'ember-metal/mixin';
import { run as runDebug } from 'ember-debug';

module('Object model test harness modifications');

runDebug(function() {
  test('Ember.Component throws without `_super` in init', function(assert) {
    assert.throws(function() {
      Component.extend({
        init() {
          // do not call super
        }
      });
    }, /Must call `this._super\(...arguments\)`/);
  });

  test('Ember.Component throws without `_super` in a mixins init', function(assert) {
    assert.throws(function() {
      let FooMixin = Mixin.create({
        init() {
          // do not call super
        }
      });

      Component.extend(FooMixin);
    }, /Must call `this._super\(...arguments\)`/);
  });

  test('Ember.Component throws without `_super` with both mixins and init', function(assert) {
    assert.throws(function() {
      let FooMixin = Mixin.create({
        init() {
          this._super(...arguments);
        }
      });

      Component.extend(FooMixin, {
        init() {
          // does not call super
        }
      });
    }, /Must call `this._super\(...arguments\)`/);
  });

  test('Ember.Component throws without `_super` in willDestroy', function(assert) {
    assert.throws(function() {
      Component.extend({
        willDestroy() {
          // do not call super
        }
      });
    }, /Must call `this._super\(...arguments\)`/);
  });


  test('Ember.Route throws without `_super` in init', function(assert) {
    assert.throws(function() {
      Route.extend({
        init() {
          // do not call super
        }
      });
    }, /Must call `this._super\(...arguments\)`/);
  });

  test('Ember.Controller throws without `_super` in init', function(assert) {
    assert.throws(function() {
      Controller.extend({
        init() {
          // do not call super
        }
      });
    }, /Must call `this._super\(...arguments\)`/);
  });

  test('Ember.Service throws without `_super` in init', function(assert) {
    assert.throws(function() {
      Service.extend({
        init() {
          // do not call super
        }
      });
    }, /Must call `this._super\(...arguments\)`/);
  });
});
