import { module, test } from 'qunit';
import roundTime from 'web-client/utilities/events/round-time';
import { TEST_DATE_FORMAT } from 'web-client/tests/helpers/assert-dates-match';
import moment from 'moment';

module('utilities/events/round-time');

test('rounding time up to a half-hour with a date object', function(assert) {
  let date = parseDate('2017-01-01 01:15:01');
  let roundedDate = roundTime(date);

  assert.datesMatch(roundedDate, '2017-01-01 01:30:00', 'minutes rounded up');
});

test('rounding time up to a full hour with a date object', function(assert) {
  let date = parseDate('2017-01-01 01:45:01');
  let roundedDate = roundTime(date);

  assert.datesMatch(roundedDate, '2017-01-01 02:00:00', 'minutes rounded up');
});

test('rounding time down to a half-hour with a date object', function(assert) {
  let date = parseDate('2017-01-01 01:44:01');
  let roundedDate = roundTime(date);

  assert.datesMatch(roundedDate, '2017-01-01 01:30:00', 'minutes rounded down');
});

test('rounding time down to a full hour with a date object', function(assert) {
  let date = parseDate('2017-01-01 01:14:01');
  let roundedDate = roundTime(date);

  assert.datesMatch(roundedDate, '2017-01-01 01:00:00', 'minutes rounded down');
});

test('object type returned is the same as that sent', function(assert) {
  let date = new Date();

  assert.ok(roundTime(date) instanceof Date, 'passing date returns date');
  assert.ok(moment.isMoment(roundTime(moment(date))), 'passing moment returns moment');
});

function parseDate(string) {
  return moment(string, TEST_DATE_FORMAT);
}
