import { test, module } from 'qunit';
import formatNumber from 'web-client/utilities/format-number';

module('Unit | Utilities | format-number');

test('formatting with no options', function(assert) {
  assert.equal(formatNumber(1234567.123), '1,234,567.123');
});

test('formatting with a separator', function(assert) {
  assert.equal(formatNumber(1234567, { separator: ' ' }), '1 234 567');
});

test('formatting with scale', function(assert) {
  assert.equal(formatNumber(123.4567, { scale: 2 }), '123.46', 'truncates to scale');
  assert.equal(formatNumber(123.0, { scale: 2 }), '123.00', 'pads with zeros');
});

test('formatting with a scale and separator', function(assert) {
  assert.equal(formatNumber(8473.231, { scale: 1, separator: '|'}), '8|473.2', 'formats properly');
});

test('non-number inputs', function(assert) {
  assert.equal(formatNumber('some-string'), 'some-string', 'passes through non-numeric strings');
  assert.equal(formatNumber('1000.23', { separator: ',', scale: 1 }), '1,000.2', 'coerces numeric strings');
  assert.strictEqual(formatNumber(undefined), '0', 'undefined defaults to zero');
  assert.strictEqual(formatNumber(null), '0', 'null defaults to zero');
  assert.strictEqual(formatNumber(NaN), '0', 'NaN defaults to zero');
});
