import { module, test } from 'qunit';
import { matchXTags, generateFragments } from 'web-client/utilities/i18n-utils';


module('Unit | Utility | I18n Utils');

test('generates fragments correctly', function(assert) {
  assert.deepEqual(generateFragments('hello', []), ['hello']);

  assert.deepEqual(
      generateFragments(
          'Submit a request via our <x:link>contact form</x:link>',
          ['<x:link>contact form</x:link>']),
      ['Submit a request via our ', '<x:link>contact form</x:link>']
  );

  assert.deepEqual(
      generateFragments(
          'Submit a request via our <x:link>contact form</x:link>',
          ['<x:link>contact form</x:link>']),
      ['Submit a request via our ', '<x:link>contact form</x:link>']
  );


  assert.deepEqual(
      generateFragments(
          'Hey {name}! Just started watching? <x:link>Click to learn more about {game}</x:link>',
          ['{name}', '<x:link>Click to learn more about {game}</x:link>']),
      ['Hey ', '{name}', '! Just started watching? ', '<x:link>Click to learn more about {game}</x:link>']
  );
});

test('Does generate fragments correctly when strings have characters that need to be regex escaped', function(assert) {
  assert.deepEqual(
    generateFragments(
      'Top <x:pill>(All)</x:pill>', 
      ['<x:pill>(All)</x:pill>']),
    ['Top ', '<x:pill>(All)</x:pill>']
  );

  assert.deepEqual(
    generateFragments(
      'Top <x:pill>($All)</x:pill>', 
      ['<x:pill>($All)</x:pill>']),
    ['Top ', '<x:pill>($All)</x:pill>']
  );

  assert.deepEqual(
    generateFragments(
      'Top$$ <x:pill>(All)</x:pill>', 
      ['<x:pill>(All)</x:pill>']),
    ['Top$$ ', '<x:pill>(All)</x:pill>']
  );

});

test('matches x tags correctly', function(assert) {
  assert.deepEqual(matchXTags('hello'), []);

  assert.deepEqual(
      matchXTags('Submit a request via our <x:link>contact form</x:link>', []),
      []
  );

  assert.deepEqual(
      matchXTags('Submit a request via our <x:link>contact form</x:link>', ['x:link']),
      ['<x:link>contact form</x:link>']
  );

  assert.deepEqual(
      matchXTags('Hey {name}! Just started watching? <x:link>Click to learn more about {game}</x:link>', ['x:link']),
      ['<x:link>Click to learn more about {game}</x:link>']
  );
});

test('does not match html tags', function(assert) {
  assert.deepEqual(
      matchXTags('Should <b>not</b> be matched'), []
  );
});
