import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import injectController from 'web-client/utilities/inject-controller';
import EmberObject from 'ember-object';
import Controller from 'ember-controller';

let MyController;

moduleForIntegration('Unit | Utilities | inject-controller', {
  beforeEach() {
    MyController = Controller.extend();
    this.owner.register('controller:my-controller', MyController);
  }
});

test('injects a named controller', function(assert) {
  const MyObject = EmberObject.extend({
    localController: injectController('myController')
  });

  this.owner.register('custom:my-object', MyObject);

  let myObject = this.owner.lookup('custom:my-object');
  let injectedController = myObject.get('localController');

  assert.ok(injectedController instanceof MyController, 'injected the controller');
});

test('finds controller according to property name', function(assert) {
  const MyObject = EmberObject.extend({
    myController: injectController()
  });

  this.owner.register('custom:my-object', MyObject);

  let myObject = this.owner.lookup('custom:my-object');
  let injectedController = myObject.get('myController');

  assert.ok(injectedController instanceof MyController, 'injected the controller');
});
