import { module, test } from 'qunit';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

module('Unit | Utility | normalize-video-id');

test('for a prefixed id', function(assert) {
  assert.equal(normalizeVideoId('v1234'), '1234', 'should remove the v prefix from the ID');
});

test('for a non-prefixed id', function(assert) {
  assert.equal(normalizeVideoId('1234'), '1234', 'should not modify the ID');
});

test('for an int value', function(assert) {
  assert.equal(normalizeVideoId(1234), 1234, 'should leave the int as is');
});

test('for a null value', function(assert) {
  assert.equal(normalizeVideoId(null), null, 'should gracefully handle a falsy type');
});
