import Ember from 'ember';
import { normalizeReactions, mergeReactions } from 'web-client/utilities/reactions';
import { module, test } from 'qunit';

const { merge, copy } = Ember;

module('Unit | Utility | reactions');

let endorseEmote = {emote: "endorse", count: 1, user_ids: []};
let reactionsMap = {
  endorse: endorseEmote,
  88: {emote: "PogChamp", count: 1, user_ids: []}
};

let normalizedReactions = {
  endorse: {emoteId: 'endorse', emoteName: 'endorse', count: 1, userIds: []},
  88: {emoteId: 88, emoteName: 'PogChamp', count: 1, userIds: []}
};

test('normalizeReactions works', function(assert) {
  assert.deepEqual(normalizeReactions({endorse: reactionsMap.endorse}), [normalizedReactions.endorse], "reactions object normalized into an array");
});

test('mergeReactions works', function(assert) {
  let merged = mergeReactions([endorseEmote], [
    merge(copy(endorseEmote), {count: 2}),
    reactionsMap[88] // PogChamp
  ]);
  assert.equal(merged.length, 2, "correct number of merged reactions");
  assert.ok(merged.some(reaction => reaction.emoteName === 'endorse' && reaction.count === 2), "existing emote merged successfully");
  assert.ok(merged.some(reaction => reaction.emoteName === 'PogChamp' && reaction.count === 1), "new emote added successfully");
});
