import { ROUTES, routeMatches } from 'web-client/utilities/route-matcher';
import { module, test } from 'qunit';

module('Unit | Utility | route matching');

test('when called with the channel_any route', function(assert) {
  assert.expect(5);

  let matchingRoutes = [
    'user.channel.index',
    'user.channel.videos',
    'user.channel.following',
    'user.channel.followers'
  ];

  let nonMatchingRoute = 'following.channels';

  matchingRoutes.forEach((route) => {
    assert.ok(routeMatches(route, ROUTES.CHANNEL_ANY), `matches the ${route} route`);
  });

  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.CHANNEL_ANY), 'fails to match a non-matching route');
});

test('when called with the channel page route', function(assert) {
  let matchingRoute = 'user.channel.index';
  let nonMatchingRoute = 'user.channel';

  assert.ok(routeMatches(matchingRoute, ROUTES.CHANNEL_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.CHANNEL_PAGE), 'fails to match the wrong route');
});

test('when called with the videos page route', function(assert) {
  let matchingRoute = 'user.channel.videos';
  let nonMatchingRoute = 'user.channel';

  assert.ok(routeMatches(matchingRoute, ROUTES.VIDEOS_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.VIDEOS_PAGE), 'fails to match the wrong route');
});

test('when called with the clips page route', function(assert) {
  let matchingRoute = 'user.channel.clips';
  let nonMatchingRoute = 'user.channel';

  assert.ok(routeMatches(matchingRoute, ROUTES.CLIPS_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.CLIPS_PAGE), 'fails to match the wrong route');
});

test('when called with the collections page route', function(assert) {
  let matchingRoute = 'user.channel.collections';
  let nonMatchingRoute = 'user.channel';

  assert.ok(routeMatches(matchingRoute, ROUTES.COLLECTIONS_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.COLLECTIONS_PAGE), 'fails to match the wrong route');
});

test('when called with the vods page route', function(assert) {
  let matchingRoute = 'user.vod';
  let nonMatchingRoute = 'user.channel.index';

  assert.ok(routeMatches(matchingRoute, ROUTES.VOD_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.VOD_PAGE), 'fails to match the wrong route');
});

test('when called with the following page route', function(assert) {
  let matchingRoute = 'user.channel.following';
  let nonMatchingRoute = 'user.channel';

  assert.ok(routeMatches(matchingRoute, ROUTES.FOLLOWING_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.FOLLOWING_PAGE), 'fails to match the wrong route');
});

test('when called with the followers page route', function(assert) {
  let matchingRoute = 'user.channel.followers';
  let nonMatchingRoute = 'user.channel';

  assert.ok(routeMatches(matchingRoute, ROUTES.FOLLOWERS_PAGE), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.FOLLOWERS_PAGE), 'fails to match the wrong route');
});

test('when called with the directory page route', function(assert) {
  let matchingRoute = 'directory.following';
  let nonMatchingRoute = 'user.dashboards';

  assert.ok(routeMatches(matchingRoute, ROUTES.DIRECTORY), 'matches the correct route');
  assert.notOk(routeMatches(nonMatchingRoute, ROUTES.DIRECTORY), 'fails to match the wrong route');
});

test('when called with a list of routes', function(assert) {
  let routes = [
    ROUTES.CHANNEL_PAGE,
    ROUTES.VOD_PAGE,
    ROUTES.VIDEOS_PAGE
  ];

  let matchingRoute = 'user.channel.index';
  let nonMatchingRoute = 'user.channel.following';

  assert.ok(routeMatches(matchingRoute, routes), 'matches a route contained in the list');
  assert.notOk(routeMatches(nonMatchingRoute, routes), 'fails to match a route not in the list');
});
