import { module, test } from 'qunit';
import { StatsNode } from 'web-client/utilities/video-stats/stats-node';

const LABEL = 'viewcount';
const VALUE = 43;
const TYPE = 'metric';

module('Unit | Utils | video-stats/stats-node', {
  beforeEach() {
    this.subject = new StatsNode(LABEL, VALUE, TYPE);
  }
});

test('getters', function(assert) {
  assert.equal(this.subject.label, LABEL, 'should retrieve label');
  assert.equal(this.subject.value, VALUE, 'should retrieve value');
  assert.equal(this.subject.type, TYPE, 'should retrieve type');
  assert.deepEqual(this.subject.nodes, {}, 'should retrieve nodes');
});

test('setChildNode', function(assert) {
  let childNode = new StatsNode('test', 2, 'foo');
  this.subject.setChildNode(childNode);

  assert.equal(this.subject._nodes[childNode.label], childNode, 'should have properly added the child node');
});

test('getChildNode', function(assert) {
  let childNode = new StatsNode('test', 2, 'foo');
  this.subject.setChildNode(childNode);
  let retrievedNode = this.subject.getChildNode('test');

  assert.equal(retrievedNode, childNode, 'should properly retrieve the set node');
});
