import { module, test } from 'qunit';
import { StatsPoint } from 'web-client/utilities/video-stats/stats-point';
import { StatsNode } from 'web-client/utilities/video-stats/stats-node';

const TIMESTAMP = new Date(1991, 3, 7).toString();
const CHILD_NODE = new StatsNode('foo', 16, 'metric');

module('Unit | Utils | video-stats/stats-point', {
  beforeEach() {
    this.subject = new StatsPoint(TIMESTAMP);
  }
});

test('getters', function(assert) {
  assert.equal(this.subject.timeStamp, TIMESTAMP, 'should get timestamp');
});

test('getNodeFor', function(assert) {
  this.subject.setChildNodeFor('', CHILD_NODE);
  assert.equal(this.subject.getNodeFor('foo'), CHILD_NODE, 'should find the correct child node');
});

test('getNodeFor when the selector is empty or the empty string', function(assert) {
  assert.equal(this.subject.getNodeFor([]), this.subject._node, 'should return the root node');
  assert.equal(this.subject.getNodeFor(''), this.subject._node, 'should return the root node');
});

test("getNodeFor when the specified selectors don't map to a node", function(assert) {
  assert.equal(this.subject.getNodeFor(['bad', 'selectors']), null, 'should return null');
});

test('getNodeFor a deeply nested node', function(assert) {
  let intermediateLabel = 'bar';
  let intermediateNode = new StatsNode(intermediateLabel, 3);
  intermediateNode.setChildNode(CHILD_NODE);
  this.subject.setChildNodeFor('', intermediateNode);

  assert.equal(this.subject.getNodeFor(['bar', CHILD_NODE.label]), CHILD_NODE, 'should retrieve the nested child node');
});

test('setChildNodeFor', function(assert) {
  this.subject.setChildNodeFor('', CHILD_NODE);
  assert.equal(this.subject.getNodeFor(CHILD_NODE.label), CHILD_NODE, 'should properly set the child node');
});

test('setChildNodeFor for a falsy node', function(assert) {
  let func = () => { this.subject.setChildNodeFor('', null); };
  assert.throws(func, 'should throw an error');
});

test('setChildNodeFor for an invalid parent selector', function(assert) {
  let func = () => { this.subject.setChildNodeFor('badSelector', CHILD_NODE); };
  assert.throws(func, 'should throw an error');
});
