import { module, test } from 'qunit';
import titleizeFilename from 'web-client/utilities/video-uploader/titleize-filename';

module('Unit | Utility | titleize-filename');

test('makes filenames look like titles', function(assert) {
  let input    = 'some-funKy__title  of a Video.why.dots.mp4';
  let expected = 'some funKy title of a Video why dots';
  assert.equal(titleizeFilename(input), expected, 'formats a filename');
});

test('truncates filenames at maxLength', function(assert) {
  assert.equal(
    titleizeFilename('123456789.mp4', { maxLength: 3 }),
    '123',
    'truncates the filename when it exceeds the maxLength value'
  );
});

test('still returns a title when there is no extension', function(assert) {
  assert.equal(
    titleizeFilename('noextension'),
    'noextension',
    'filename returned without modification'
  );
});

test('still returns a title when there are no characters before the last dot', function(assert) {
  assert.equal(
    titleizeFilename('.onlyextension'),
    'onlyextension',
    'filename contains the content after the dot'
  );
});
